/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.logo.dialog.comp;

import CH.ifa.draw.framework.Tool;
import DE.siemens.ad.logo.app.Application;
import DE.siemens.ad.logo.app.Editor;
import DE.siemens.ad.logo.comm.DataTransfer;
import DE.siemens.ad.logo.dialog.comp.IndexedJTablePanel;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.hardware.Logo7;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.LogoError;
import DE.siemens.ad.logo.util.Util;
import DE.siemens.ad.pdraw.app.LogoComfort;
import DE.siemens.ad.pdraw.simulation.OnlineTestInterpreter;
import DE.siemens.ad.pdraw.simulation.OnlineTestTool;
import DE.siemens.ad.pdraw.simulation.RunningTool;
import DE.siemens.ad.pdraw.simulation.SimulationTool;
import DE.siemens.ad.pdraw.standard.LogoDrawing;
import DE.siemens.ad.pdraw.standard.LogoDrawingView;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class DataTableWindow
extends JDialog {
    private IndexedJTablePanel fTablePanel;
    private JTable fTable;
    private int fVMSize;
    private int fMaxLength;
    private JComboBox fValueType;
    private DefaultComboBoxModel fFullTypeModel;
    private DefaultComboBoxModel fBitTypeModel;
    private Interpreter fInterpreter;
    private static final String BIT = Language.getString("dialog.dataTable.bit", "Bit");
    private static final String SIGNED = Language.getString("dialog.dataTable.signed", "Signed");
    private static final String UNSIGNED = Language.getString("dialog.dataTable.unSigned", "Unsigned");
    private static final String HEX = Language.getString("dialog.dataTable.hex", "Hex");
    private static final String BINARY = Language.getString("dialog.dataTable.binary", "Binary");
    private static final String ASCII = Language.getString("dialog.dataTable.ascii", "ASCII");
    private static final String ERROR_ILLEGAL_DATA = "illegalData";
    private static final String ERROR_OUT_OF_RANGE = "outOfRange";
    private Tool fTool;
    private DataTransfer fDataTransfer;
    private boolean fIsTableEnabled;
    private Hardware fHardware;

    protected DataTableWindow(JFrame parent) {
        super(parent);
        this.init();
    }

    protected DataTableWindow(JDialog parent) {
        super(parent);
        this.init();
    }

    public static DataTableWindow createDataTableWindow(Editor editor) {
        DataTableWindow dataTableWindow = null;
        Window parentWindow = editor.getApplicationSurface().getWindow();
        if (parentWindow instanceof JDialog) {
            dataTableWindow = new DataTableWindow((JDialog)parentWindow);
        } else if (parentWindow instanceof JFrame) {
            dataTableWindow = new DataTableWindow((JFrame)parentWindow);
        } else {
            throw new IllegalArgumentException("Parent of a PIControllerWindow must be a JDialog or JFrame.");
        }
        Tool tool = ((LogoComfort)editor).tool();
        dataTableWindow.setTool(tool);
        if (tool instanceof SimulationTool) {
            dataTableWindow.setInterpreter(((SimulationTool)tool).getInterpreter());
        }
        if (tool instanceof OnlineTestTool) {
            dataTableWindow.setInterpreter(((OnlineTestTool)tool).getInterpreter());
            dataTableWindow.setDataTransfer(((OnlineTestTool)tool).getDataTransfer());
        }
        return dataTableWindow;
    }

    public void setDataTransfer(DataTransfer dt) {
        this.fDataTransfer = dt;
    }

    private void setInterpreter(Interpreter interpreter) {
        this.fInterpreter = interpreter;
    }

    public void setTool(Tool tool) {
        this.fTool = tool;
    }

    private void init() {
        this.setDefaultCloseOperation(2);
        this.setBounds(100, 150, 525, 322);
        this.fHardware = ((LogoDrawing)((LogoDrawingView)Application.getInstance().getActiveApplicationSurface().getEditor().getView()).drawing()).getWiringDiagram().getHardware();
        this.fMaxLength = this.fHardware.getIntProperty("dataTableMaximumLength");
        this.fVMSize = this.fHardware.getIntProperty("nStartAddress");
        this.setTitle(Language.getString("tool.dataTable", "Data Table"));
        String[] data1 = new String[]{SIGNED, UNSIGNED, HEX, BINARY, ASCII};
        this.fFullTypeModel = new DefaultComboBoxModel<String>(data1);
        String[] data2 = new String[]{BIT};
        this.fBitTypeModel = new DefaultComboBoxModel<String>(data2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.initJTable(), "Center");
    }

    private IndexedJTablePanel initJTable() {
        if (this.fTablePanel == null) {
            Object[] fColumnName = new String[]{Language.getString("tool.vmConfigure.address", "Address"), Language.getString("dialog.switch.type", "Type"), Language.getString("dialog.switch.currentValue", "Current Value"), Language.getString("dialog.dataTable.newValue", "New Value")};
            DefaultTableModel model = new DefaultTableModel(fColumnName, 0);
            JTable jtable = new JTable(model);
            this.fTablePanel = new IndexedJTablePanel(jtable, this.fMaxLength);
            this.fTablePanel.setPreferredSize(new Dimension(525, 293));
            this.fTablePanel.setRowHeight(22);
            this.fTable = this.fTablePanel.getTable();
            this.fTable.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent e) {
                    if (DataTableWindow.this.fTable.columnAtPoint(e.getPoint()) != DataTableWindow.this.getValueTypeIndex()) {
                        super.mouseClicked(e);
                        return;
                    }
                    String address = (String)DataTableWindow.this.fTable.getValueAt(DataTableWindow.this.fTable.rowAtPoint(e.getPoint()), DataTableWindow.this.getAddressIndex());
                    if (address != null && DataTableWindow.this.checkAddress(address) && address.indexOf(".") != -1) {
                        DataTableWindow.this.fValueType.setModel(DataTableWindow.this.fBitTypeModel);
                    } else {
                        DataTableWindow.this.fValueType.setModel(DataTableWindow.this.fFullTypeModel);
                    }
                    DataTableWindow.this.fValueType.repaint();
                }
            });
            DefaultCellEditor cvEditor = new DefaultCellEditor(new JTextField()){

                public boolean isCellEditable(EventObject anEvent) {
                    return false;
                }
            };
            this.fTable.getColumnModel().getColumn(this.getCVIndex()).setCellEditor(cvEditor);
            TableColumn addressColumn = this.fTable.getColumnModel().getColumn(this.getAddressIndex());
            addressColumn.setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    if (value == null || DataTableWindow.this.checkAddress(value.toString())) {
                        this.setForeground(Color.BLACK);
                    } else {
                        this.setForeground(Color.RED);
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
            addressColumn.setCellEditor(new DefaultCellEditor(new JTextField()){

                public boolean stopCellEditing() {
                    int[] readRequestData;
                    int row = DataTableWindow.this.fTable.getEditingRow();
                    String inputStr = this.getCellEditorValue().toString();
                    if (DataTableWindow.this.checkAddress(inputStr)) {
                        String removeLeading0 = this.removeLeading0(inputStr);
                        ((JTextField)this.getComponent()).setText(removeLeading0.toUpperCase());
                        DataTableWindow.this.fTable.setValueAt(removeLeading0.toUpperCase(), row, DataTableWindow.this.getAddressIndex());
                        if (removeLeading0.indexOf(".") != -1) {
                            DataTableWindow.this.fTable.setValueAt(BIT, row, DataTableWindow.this.getValueTypeIndex());
                        } else {
                            DataTableWindow.this.fTable.setValueAt(SIGNED, row, DataTableWindow.this.getValueTypeIndex());
                        }
                    } else {
                        DataTableWindow.this.fTable.setValueAt(null, row, DataTableWindow.this.getValueTypeIndex());
                        DataTableWindow.this.fTable.setValueAt(null, row, DataTableWindow.this.getCVIndex());
                    }
                    if (DataTableWindow.this.fTool instanceof OnlineTestTool && (readRequestData = DataTableWindow.this.getReadRequestData()).length > 3) {
                        ((OnlineTestInterpreter)DataTableWindow.this.fInterpreter).setReadRequestedData(readRequestData);
                        DataTableWindow.this.fDataTransfer.sendDataTableRequest(false, readRequestData);
                    }
                    return super.stopCellEditing();
                }

                private String removeLeading0(String sourceStr) {
                    String lowerAddress = sourceStr.toLowerCase();
                    if (lowerAddress.startsWith("v") && lowerAddress.indexOf(".") != -1) {
                        Double dAddr = Double.valueOf(lowerAddress.substring(1, lowerAddress.length()));
                        return lowerAddress.substring(0, 1) + String.valueOf(dAddr);
                    }
                    int addr = Integer.valueOf(lowerAddress.substring(2, lowerAddress.length()));
                    return lowerAddress.substring(0, 2) + String.valueOf(addr);
                }
            });
            TableColumn nvColumn = this.fTable.getColumnModel().getColumn(this.getNVIndex());
            DefaultCellEditor nvEditor = new DefaultCellEditor(new JTextField()){

                public boolean stopCellEditing() {
                    block12: {
                        int row = DataTableWindow.this.fTable.getEditingRow();
                        Object address = DataTableWindow.this.fTable.getValueAt(row, DataTableWindow.this.getAddressIndex());
                        if (address != null && DataTableWindow.this.checkAddress(address.toString()) && !address.toString().toLowerCase().startsWith("ib") && !address.toString().toLowerCase().startsWith("qb") && !address.toString().toLowerCase().startsWith("mb")) {
                            String valueType = DataTableWindow.this.fTable.getValueAt(row, DataTableWindow.this.getValueTypeIndex()).toString();
                            String nvValue = this.getCellEditorValue().toString();
                            if (valueType != null && nvValue != null && nvValue.length() > 0) {
                                String lowerAddr = address.toString().toLowerCase();
                                if (lowerAddr.startsWith("v") && lowerAddr.indexOf(".") != -1) {
                                    if (nvValue.toLowerCase().equals("true")) {
                                        nvValue = String.valueOf(1);
                                    } else if (nvValue.toLowerCase().equals("false")) {
                                        nvValue = String.valueOf(0);
                                    }
                                }
                                try {
                                    long value = DataTableWindow.this.nvToLongValue(nvValue, address.toString());
                                    if (DataTableWindow.this.fTool instanceof SimulationTool) {
                                        DataTableWindow.this.setVMValue((int)value, address.toString());
                                    } else if (DataTableWindow.this.fTool instanceof OnlineTestTool) {
                                        int[] writeRequestData = DataTableWindow.this.getWriteRequestData((int)value, address.toString());
                                        DataTableWindow.this.fDataTransfer.sendDataTableRequest(true, writeRequestData);
                                    }
                                    ((JTextField)this.getComponent()).setText("");
                                }
                                catch (IllegalVMValueException e) {
                                    if (e.getMessage().equals(DataTableWindow.ERROR_ILLEGAL_DATA)) {
                                        new LogoError(null, "dialog.dataTable.error.wrongDataFormater", "The data format is incorrect.").display();
                                    }
                                    if (!e.getMessage().equals(DataTableWindow.ERROR_OUT_OF_RANGE)) break block12;
                                    new LogoError(null, "dialog.dataTable.error.outofRange", "The data value is out of range.").display();
                                }
                            }
                        }
                    }
                    return super.stopCellEditing();
                }

                public boolean isCellEditable(EventObject anEvent) {
                    int row = anEvent instanceof MouseEvent ? DataTableWindow.this.fTable.rowAtPoint(((MouseEvent)anEvent).getPoint()) : DataTableWindow.this.fTable.getSelectedRow();
                    Object address = DataTableWindow.this.fTable.getValueAt(row, DataTableWindow.this.getAddressIndex());
                    if (address == null) {
                        this.getComponent().setEnabled(true);
                        return super.isCellEditable(anEvent);
                    }
                    String add = address.toString().toLowerCase();
                    this.getComponent().setEnabled(!DataTableWindow.this.checkAddress(add) || !add.startsWith("qb") && !add.startsWith("mb") && !add.startsWith("ib"));
                    return super.isCellEditable(anEvent);
                }
            };
            nvColumn.setCellEditor(nvEditor);
            nvColumn.setCellRenderer(new DefaultTableCellRenderer(){

                public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                    Object address = DataTableWindow.this.fTable.getValueAt(row, DataTableWindow.this.getAddressIndex());
                    if (value != null && address != null) {
                        try {
                            DataTableWindow.this.nvToLongValue(value.toString(), address.toString());
                        }
                        catch (IllegalVMValueException e) {
                            this.setForeground(Color.RED);
                        }
                        this.setForeground(Color.BLACK);
                    } else {
                        this.setForeground(Color.RED);
                    }
                    return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                }
            });
            this.fValueType = new JComboBox();
            DefaultCellEditor typeEditor = new DefaultCellEditor(this.fValueType);
            typeEditor.setClickCountToStart(2);
            this.fTable.getColumnModel().getColumn(this.getValueTypeIndex()).setCellEditor(typeEditor);
            if (this.fTable.getRowCount() < this.fMaxLength) {
                this.fTablePanel.addRowIntoJTable(-1, null);
            }
        }
        return this.fTablePanel;
    }

    private int getAddressIndex() {
        return 0;
    }

    private int getValueTypeIndex() {
        return 1;
    }

    private int getCVIndex() {
        return 2;
    }

    private int getNVIndex() {
        return 3;
    }

    public Interpreter getInterpreter() {
        return this.fInterpreter;
    }

    public DataTransfer getDataTransfer() {
        return this.fDataTransfer;
    }

    public int[] getReadRequestData() {
        String type;
        String address;
        int counter = 0;
        int checksum = 0;
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            address = (String)this.fTable.getValueAt(i, this.getAddressIndex());
            type = (String)this.fTable.getValueAt(i, this.getValueTypeIndex());
            if (address == null || type == null || !this.checkAddress(address)) continue;
            ++counter;
        }
        int readDataLength = 1 + 3 * counter + 2;
        int[] readData = new int[readDataLength];
        readData[0] = counter;
        int index = 1;
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            address = (String)this.fTable.getValueAt(i, this.getAddressIndex());
            type = (String)this.fTable.getValueAt(i, this.getValueTypeIndex());
            if (address == null || type == null || !this.checkAddress(address)) continue;
            int VMAddr = this.getDataAddr(address);
            int VMLength = this.getDataLength(address);
            readData[index++] = VMAddr & 0xFF;
            readData[index++] = VMAddr >> 8 & 0xFF;
            readData[index++] = VMLength;
            checksum += VMLength << 10 + VMAddr;
        }
        readData[index++] = checksum & 0xFF;
        readData[index++] = checksum >> 8 & 0xFF;
        return readData;
    }

    protected int[] getWriteRequestData(int value, String address) {
        int length = this.getDataLength(address);
        int addr = this.getDataAddr(address);
        int telegramLength = 6 + length;
        int[] writeData = new int[telegramLength];
        writeData[0] = (telegramLength -= 2) & 0xFF;
        writeData[1] = telegramLength >> 8;
        writeData[2] = 1;
        writeData[3] = addr & 0xFF;
        writeData[4] = addr >> 8;
        writeData[5] = length;
        int index = 6;
        if (length == 1) {
            String lowerValue = address.toLowerCase();
            if (lowerValue.startsWith("v") && lowerValue.indexOf(".") != -1) {
                int bit = Integer.valueOf(lowerValue.substring(lowerValue.indexOf(".") + 1));
                int byteValue = this.fInterpreter.readVM(length, addr);
                if (value == 0) {
                    value = byteValue & ~(1 << bit);
                } else if (value == 1) {
                    value = byteValue | 1 << bit;
                }
                writeData[index++] = value;
            } else if (lowerValue.startsWith("vb")) {
                writeData[index++] = value;
            }
        } else if (length == 2) {
            writeData[index++] = value >> 8 & 0xFF;
            writeData[index++] = value & 0xFF;
        } else if (length == 4) {
            writeData[index++] = value >> 24 & 0xFF;
            writeData[index++] = value >> 16 & 0xFF;
            writeData[index++] = value >> 8 & 0xFF;
            writeData[index++] = value & 0xFF;
        }
        return writeData;
    }

    public void offLineDataFiller() {
        for (int i = 0; i < this.fTable.getRowCount(); ++i) {
            String address = (String)this.fTable.getValueAt(i, this.getAddressIndex());
            String type = (String)this.fTable.getValueAt(i, this.getValueTypeIndex());
            if (address == null || type == null || !this.checkAddress(address)) continue;
            this.fTable.setValueAt(this.getVMValue(address, (String)this.fTable.getValueAt(i, this.getValueTypeIndex())), i, this.getCVIndex());
        }
    }

    private void setVMValue(int value, String address) {
        int vmAddress;
        int length;
        String lowerValue = address.toLowerCase();
        if (lowerValue.startsWith("vb")) {
            length = 1;
            vmAddress = Integer.valueOf(lowerValue.substring(2, lowerValue.length()));
        } else if (lowerValue.startsWith("vw")) {
            length = 2;
            vmAddress = Integer.valueOf(lowerValue.substring(2, lowerValue.length()));
        } else if (lowerValue.startsWith("vd")) {
            length = 4;
            vmAddress = Integer.valueOf(lowerValue.substring(2, lowerValue.length()));
        } else if (lowerValue.startsWith("v") && lowerValue.indexOf(".") != -1) {
            length = 1;
            vmAddress = Integer.valueOf(lowerValue.substring(1, lowerValue.indexOf(".")));
            int bit = Integer.valueOf(lowerValue.substring(lowerValue.indexOf(".") + 1));
            int byteValue = this.fInterpreter.readVM(length, vmAddress);
            if (value == 0) {
                value = byteValue & ~(1 << bit);
            } else if (value == 1) {
                value = byteValue | 1 << bit;
            }
        } else {
            return;
        }
        this.fInterpreter.writeVM(length, vmAddress, value);
    }

    private String getVMValue(String address, String type) {
        String ret;
        String lowerAddress = address.toLowerCase();
        long unsignedValue = 0L;
        int length = 0;
        if (lowerAddress.startsWith("vb")) {
            unsignedValue = this.fInterpreter.readVM(1, Integer.valueOf(lowerAddress.substring(2, lowerAddress.length())));
            length = 8;
        } else if (lowerAddress.startsWith("vw")) {
            unsignedValue = this.fInterpreter.readVM(2, Integer.valueOf(lowerAddress.substring(2, lowerAddress.length())));
            length = 16;
        } else if (lowerAddress.startsWith("vd")) {
            long value = this.fInterpreter.readVM(4, Integer.valueOf(lowerAddress.substring(2, lowerAddress.length())));
            unsignedValue = value < 0L ? value << 32 >>> 32 : value;
            length = 32;
        } else if (lowerAddress.startsWith("v") && lowerAddress.indexOf(".") != -1) {
            unsignedValue = this.fInterpreter.readVM(1, Integer.valueOf(lowerAddress.substring(1, lowerAddress.indexOf("."))));
            int bit = Integer.valueOf(lowerAddress.substring(lowerAddress.indexOf(".") + 1));
            unsignedValue = unsignedValue >> bit & 1L;
        } else if (lowerAddress.startsWith("ib")) {
            unsignedValue = this.fInterpreter.readVM(1, this.getVMAddressOfIQM(6, Integer.valueOf(lowerAddress.substring(2, lowerAddress.length()))));
            length = 8;
        } else if (lowerAddress.startsWith("qb")) {
            unsignedValue = this.fInterpreter.readVM(1, this.getVMAddressOfIQM(7, Integer.valueOf(lowerAddress.substring(2, lowerAddress.length()))));
            length = 8;
        } else if (lowerAddress.startsWith("mb")) {
            unsignedValue = this.fInterpreter.readVM(1, this.getVMAddressOfIQM(10, Integer.valueOf(lowerAddress.substring(2, lowerAddress.length()))));
            length = 8;
        }
        if (type.equals(BIT)) {
            ret = "2#" + unsignedValue;
        } else if (type.equals(SIGNED)) {
            int value = Util.toSignedValue(unsignedValue, length);
            ret = value > 0 ? "+" + value : String.valueOf(value);
        } else if (type.equals(UNSIGNED)) {
            ret = String.valueOf(unsignedValue);
        } else if (type.equals(HEX)) {
            ret = "16#" + Long.toHexString(unsignedValue).toUpperCase();
        } else if (type.equals(ASCII)) {
            ret = this.getAsciiChar((int)unsignedValue, length);
            if (ret.length() > 0) {
                ret = "'" + ret + "'";
            }
        } else if (type.equals(BINARY)) {
            ret = Long.toBinaryString(unsignedValue);
            String initialString = this.getInitialStringForBinary(address);
            ret = initialString.substring(0, initialString.length() - ret.length()) + ret;
            String temp = "";
            for (int i = 0; i < ret.length() / 8; ++i) {
                String byteStr = ret.substring(i * 8, i * 8 + 8);
                temp = temp + byteStr.substring(0, 4) + "_" + byteStr.substring(4, 8);
                if (i == ret.length() / 8 - 1) continue;
                temp = temp + "_";
            }
            ret = "2#" + temp;
        } else {
            ret = "";
        }
        return ret;
    }

    private String getInitialStringForBinary(String address) {
        String lowerAddress = address.toLowerCase();
        String ret = null;
        ret = lowerAddress.startsWith("vw") ? "0000000000000000" : (lowerAddress.startsWith("vd") ? "00000000000000000000000000000000" : "00000000");
        return ret;
    }

    private String getAsciiChar(int value, int length) {
        StringBuffer sb = new StringBuffer();
        if (length == 32) {
            sb.append((char)(value & 0xFF)).append((char)(value >> 8 & 0xFF)).append((char)(value >> 16 & 0xFF)).append((char)(value >> 24));
        } else if (length == 16) {
            sb.append((char)(value & 0xFF)).append((char)(value >> 8));
        } else if (length == 8) {
            sb.append((char)value);
        }
        return sb.toString();
    }

    private int getDataLength(String address) {
        String lowerAddress = address.toLowerCase();
        int length = 0;
        if (lowerAddress.startsWith("mb") || lowerAddress.startsWith("qb") || lowerAddress.startsWith("ib") || lowerAddress.startsWith("vb") || lowerAddress.startsWith("v") && lowerAddress.indexOf(".") != -1) {
            length = 1;
        } else if (lowerAddress.startsWith("vw")) {
            length = 2;
        } else if (lowerAddress.startsWith("vd")) {
            length = 4;
        }
        return length;
    }

    private int getDataAddr(String address) {
        String lowerAddress = address.toLowerCase();
        int addr = 0;
        if (lowerAddress.startsWith("vb") || lowerAddress.startsWith("vw") || lowerAddress.startsWith("vd")) {
            addr = Integer.valueOf(lowerAddress.substring(2, lowerAddress.length()));
        } else if (lowerAddress.startsWith("v") && lowerAddress.indexOf(".") != -1) {
            addr = Integer.valueOf(lowerAddress.substring(1, lowerAddress.indexOf(".")));
        } else if (lowerAddress.startsWith("ib")) {
            addr = this.getVMAddressOfIQM(6, Integer.valueOf(lowerAddress.substring(2, lowerAddress.length())));
        } else if (lowerAddress.startsWith("qb")) {
            addr = this.getVMAddressOfIQM(7, Integer.valueOf(lowerAddress.substring(2, lowerAddress.length())));
        } else if (lowerAddress.startsWith("mb")) {
            addr = this.getVMAddressOfIQM(10, Integer.valueOf(lowerAddress.substring(2, lowerAddress.length())));
        }
        return addr;
    }

    private boolean checkAddress(String address) {
        String rex = "([Vv][0-9]+.[0-7])|([Vv][BbWwDd][0-9]+)|([IiQqMm][Bb][0-9]+)";
        Pattern pattern = Pattern.compile(rex);
        Matcher matcher = pattern.matcher(address);
        boolean matched = matcher.matches();
        if (matched) {
            String lowerAddress = address.toLowerCase();
            int add = 0;
            int maximunAdd = 0;
            if (lowerAddress.startsWith("v") && lowerAddress.indexOf(".") != -1) {
                add = Integer.valueOf(lowerAddress.substring(1, lowerAddress.indexOf(".")));
                maximunAdd = this.fVMSize - 1;
            } else {
                add = Integer.valueOf(lowerAddress.substring(2, lowerAddress.length()));
                if (lowerAddress.startsWith("vb")) {
                    maximunAdd = this.fVMSize - 1;
                } else if (lowerAddress.startsWith("vw")) {
                    maximunAdd = this.fVMSize - 2;
                } else if (lowerAddress.startsWith("vd")) {
                    maximunAdd = this.fVMSize - 4;
                } else if (lowerAddress.startsWith("ib")) {
                    maximunAdd = 2;
                } else if (lowerAddress.startsWith("qb")) {
                    maximunAdd = 1;
                } else if (lowerAddress.startsWith("mb")) {
                    maximunAdd = 3;
                }
            }
            if (add <= maximunAdd) {
                return true;
            }
        }
        return false;
    }

    private long nvToLongValue(String value, String address) throws IllegalVMValueException {
        long ret = 0L;
        if (value.equals("")) {
            return ret;
        }
        if (value.startsWith("2#")) {
            try {
                ret = Long.parseLong(value.substring(2), 2);
            }
            catch (Exception e) {
                throw new IllegalVMValueException(ERROR_ILLEGAL_DATA);
            }
        } else if (value.startsWith("16#")) {
            try {
                ret = Long.parseLong(value.substring(3), 16);
            }
            catch (Exception e) {
                throw new IllegalVMValueException(ERROR_ILLEGAL_DATA);
            }
        } else if (value.startsWith("'")) {
            if (!value.endsWith("'")) {
                throw new IllegalVMValueException(ERROR_ILLEGAL_DATA);
            }
            for (int i = 1; i < value.length() - 1; ++i) {
                if (value.charAt(i) >= '\u007f') {
                    throw new IllegalVMValueException(ERROR_ILLEGAL_DATA);
                }
                ret |= (long)(value.charAt(i) << (i - 1) * 8);
            }
        } else if (value.startsWith("+")) {
            try {
                ret = Long.parseLong(value.replace("+", ""));
            }
            catch (Exception e) {
                throw new IllegalVMValueException(ERROR_ILLEGAL_DATA);
            }
        } else {
            try {
                ret = Long.parseLong(value);
            }
            catch (Exception e) {
                throw new IllegalVMValueException(ERROR_ILLEGAL_DATA);
            }
        }
        boolean isOutOfRange = false;
        String lowerAddress = address.toLowerCase();
        if (lowerAddress.startsWith("v") && lowerAddress.indexOf(".") != -1) {
            if (ret != 0L && ret != 1L) {
                isOutOfRange = true;
            }
        } else if (lowerAddress.startsWith("vb")) {
            if (ret > 255L || ret < -128L) {
                isOutOfRange = true;
            }
        } else if (lowerAddress.startsWith("vw")) {
            if (ret > 65535L || ret < -32768L) {
                isOutOfRange = true;
            }
        } else if (lowerAddress.startsWith("vd") && (ret > 0xFFFFFFFFL || ret < Integer.MIN_VALUE)) {
            isOutOfRange = true;
        }
        if (isOutOfRange) {
            throw new IllegalVMValueException(ERROR_OUT_OF_RANGE);
        }
        return ret;
    }

    public void setEditorActivated(boolean activated) {
        this.setVisible(activated && this.isIsTableEnabled());
    }

    public void startSimulation() {
        this.setVisible(true);
    }

    public void stopSimulation() {
        this.setVisible(false);
    }

    public boolean isIsTableEnabled() {
        return this.fIsTableEnabled;
    }

    public void setIsTableEnabled(boolean fIsTableEnabled) {
        this.fIsTableEnabled = fIsTableEnabled;
    }

    public void interpreterCycleFinished() {
        if (this.fTool instanceof RunningTool) {
            this.offLineDataFiller();
        }
    }

    protected int getVMAddressOfIQM(int type, int offset) {
        return ((Logo7)this.fHardware).getVMStartAddress(type) + offset;
    }

    class IllegalVMValueException
    extends Exception {
        public IllegalVMValueException(String message) {
            super(message);
        }
    }
}

